﻿namespace Code6587EN.Ch05.EnablePublishing
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;

    /// <summary>
    /// Console Application to enable Publishing Features on a Site
    /// </summary>
    class Program
    {
        private static readonly Guid FeatureSiteCollection = new Guid("f6924d36-2fa8-4f0b-b16d-06b7250180fa");
        private static readonly Guid FeatureSite = new Guid("94c94ca6-b32f-4da9-a9e3-1f3d343d7ecb");

        static void Main(string[] args)
        {
            // Open the Site Collection containing the Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Ensure the Publishing Infrastructure Site Collection feature is activated
                if (site.Features[FeatureSiteCollection] == null)
                    site.Features.Add(FeatureSiteCollection);

                // Open the Site
                using (var web = site.OpenWeb())
                {
                    // Ensure the Site Publishing feature is activated
                    if (web.Features[FeatureSite] == null)
                        web.Features.Add(FeatureSite);
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
